// app/page.tsx
// Data fetching logic is imported from the lib/api.ts file
import { GET_RECENT_POSTS, fetchGraphQL } from '@/lib/api'; 

// app/page.tsx (Add this interface near the top)
interface PostResponse {
  posts: {
    nodes: Post[];
  };
}

interface Post {
  title: string;
  slug: string;
  date: string;
}

export default async function Home() {
  // 1. Fetch data using the imported function and query
  const data = await fetchGraphQL(GET_RECENT_POSTS) as PostResponse;
  
  // 2. Extract the array of posts from the result
  const posts: Post[] = data.posts.nodes;
  
  return (
    <main className="flex min-h-screen flex-col items-center justify-between p-24 bg-gray-50">
      <div className="z-10 w-full max-w-5xl items-center justify-between font-mono text-sm lg:flex">
        <h1 className="text-3xl font-bold mb-8 text-indigo-700">Headless WordPress Posts</h1>
      </div>

      <div className="w-full max-w-5xl">
        {posts.length > 0 ? (
          // 3. Map over the fetched posts and render their titles
          posts.map((post) => (
            <div key={post.slug} className="mb-6 p-4 border border-gray-200 rounded-lg bg-white shadow-md">
              <h2 className="text-xl font-semibold text-gray-800">{post.title}</h2>
              <p className="text-sm text-gray-500 mt-1">
                Published: {new Date(post.date).toLocaleDateString('en-US')}
              </p>
            </div>
          ))
        ) : (
          <p className="text-lg text-red-500">Could not fetch posts. Check API URL and local WordPress status.</p>
        )}
      </div>
    </main>
  );
}