// lib/api.ts
import { request, gql } from 'graphql-request';
const API_URL = process.env.NEXT_PUBLIC_WP_API_URL; 
export async function fetchGraphQL(query: string, variables = {}) {
    if (!API_URL) {
        throw new Error('NEXT_PUBLIC_WP_API_URL is not set.');
    }
    const data = await request(API_URL, query, variables);
    return data;
}
export const GET_RECENT_POSTS = gql`
  query GetRecentPosts {
    posts(first: 10, where: { orderby: { field: DATE, order: DESC } }) {
      nodes {
        title
        slug
        date
      }
    }
  }
`;